/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.j3d.BehaviorScheduler;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryStructure;
import javax.media.j3d.GraphStructureChangeListener;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dQueryProps;
import javax.media.j3d.Locale;
import javax.media.j3d.MasterControl;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.Pipeline;
import javax.media.j3d.Renderer;
import javax.media.j3d.RenderingEnvironmentStructure;
import javax.media.j3d.RenderingError;
import javax.media.j3d.RenderingErrorListener;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.ShaderError;
import javax.media.j3d.ShaderErrorListener;
import javax.media.j3d.ShaderProgram;
import javax.media.j3d.SoundStructure;
import javax.media.j3d.TransformStructure;
import javax.media.j3d.VersionInfo;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatformRetained;

public class VirtualUniverse {
    static MasterControl mc;
    Object sceneGraphLock = new Object();
    Object behaviorLock = new Object();
    Vector listOfLocales = new Vector();
    ArrayList viewPlatforms = new ArrayList();
    Object[] viewPlatformList = null;
    boolean vpChanged = false;
    Vector backgrounds = new Vector();
    Vector clips = new Vector();
    Vector sounds = new Vector();
    Vector soundscapes = new Vector();
    BehaviorScheduler behaviorScheduler = null;
    GeometryStructure geometryStructure = null;
    TransformStructure transformStructure = null;
    BehaviorStructure behaviorStructure = null;
    SoundStructure soundStructure = null;
    RenderingEnvironmentStructure renderingEnvironmentStructure = null;
    int renderingEnvironmentStructureRefCount = 0;
    long nodeIdCount = 0L;
    int viewIdCount = 0;
    Vector nodeIdFreeList = new Vector();
    ArrayList viewIdFreeList = new ArrayList();
    int numNodes = 0;
    SetLiveState setLiveState;
    ObjectUpdate[] updateObjects = new ObjectUpdate[16];
    int updateObjectsLen = 0;
    ArrayList dirtyGeomList = new ArrayList();
    View currentView;
    boolean inBehavior = false;
    boolean enableComponent = false;
    boolean enableFocus = false;
    boolean enableKey = false;
    boolean enableMouse = false;
    boolean enableMouseMotion = false;
    boolean enableMouseWheel = false;
    int activeViewCount = 0;
    static ThreadGroup rootThreadGroup;
    private static J3dQueryProps properties;
    View regViewWaiting = null;
    View unRegViewWaiting = null;
    boolean isSceneGraphLock = false;
    private Object waitLock = new Object();
    private HashSet<GraphStructureChangeListener> structureChangeListenerSet = null;
    private HashSet<ShaderErrorListener> shaderErrorListenerSet = null;
    private ShaderErrorListener defaultShaderErrorListener = ShaderProgram.getDefaultErrorListener();
    private static HashSet<RenderingErrorListener> renderingErrorListenerSet;
    private static RenderingErrorListener defaultRenderingErrorListener;

    public VirtualUniverse() {
        this.setLiveState = new SetLiveState(this);
        this.initMCStructure();
    }

    void initMCStructure() {
        if (this.geometryStructure != null) {
            this.geometryStructure.cleanup();
        }
        this.geometryStructure = new GeometryStructure(this);
        if (this.transformStructure != null) {
            this.transformStructure.cleanup();
        }
        this.transformStructure = new TransformStructure(this);
        if (this.behaviorStructure != null) {
            this.behaviorStructure.cleanup();
        }
        this.behaviorStructure = new BehaviorStructure(this);
        if (this.soundStructure != null) {
            this.soundStructure.cleanup();
        }
        this.soundStructure = new SoundStructure(this);
        if (this.renderingEnvironmentStructure != null) {
            this.renderingEnvironmentStructure.cleanup();
        }
        this.renderingEnvironmentStructure = new RenderingEnvironmentStructure(this);
    }

    static void loadLibraries() {
    }

    void addLocale(Locale locale) {
        this.listOfLocales.addElement(locale);
    }

    public void removeLocale(Locale locale) {
        if (locale.getVirtualUniverse() != this) {
            throw new IllegalArgumentException(J3dI18N.getString("VirtualUniverse0"));
        }
        this.listOfLocales.removeElement(locale);
        locale.removeFromUniverse();
        if (this.isEmpty()) {
            mc.postRequest(MasterControl.EMPTY_UNIVERSE, this);
        }
        this.setLiveState.reset(null);
    }

    public void removeAllLocales() {
        int n2;
        for (n2 = this.listOfLocales.size() - 1; n2 > 0; --n2) {
            ((Locale)this.listOfLocales.get(n2)).removeFromUniverse();
        }
        if (n2 >= 0) {
            Locale locale = (Locale)this.listOfLocales.get(0);
            this.listOfLocales.clear();
            locale.removeFromUniverse();
        }
        mc.postRequest(MasterControl.EMPTY_UNIVERSE, this);
        this.setLiveState.reset(null);
    }

    public Enumeration getAllLocales() {
        return this.listOfLocales.elements();
    }

    public int numLocales() {
        return this.listOfLocales.size();
    }

    public static void setJ3DThreadPriority(int n2) {
        if (n2 > 10) {
            n2 = 10;
        } else if (n2 < 1) {
            n2 = 1;
        }
        mc.setThreadPriority(n2);
    }

    public static int getJ3DThreadPriority() {
        return mc.getThreadPriority();
    }

    public static final Map getProperties() {
        if (properties == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList.add("j3d.version");
            arrayList2.add(VersionInfo.getVersion());
            arrayList.add("j3d.vendor");
            arrayList2.add(VersionInfo.getVendor());
            arrayList.add("j3d.specification.version");
            arrayList2.add(VersionInfo.getSpecificationVersion());
            arrayList.add("j3d.specification.vendor");
            arrayList2.add(VersionInfo.getSpecificationVendor());
            arrayList.add("j3d.renderer");
            arrayList2.add(Pipeline.getPipeline().getRendererName());
            arrayList.add("j3d.pipeline");
            arrayList2.add(Pipeline.getPipeline().getPipelineName());
            properties = new J3dQueryProps(arrayList.toArray(new String[0]), arrayList2.toArray());
        }
        return properties;
    }

    String getNodeId() {
        String string;
        if (this.nodeIdFreeList.size() == 0) {
            string = Long.toString(this.nodeIdCount);
            ++this.nodeIdCount;
        } else {
            int n2 = this.nodeIdFreeList.size() - 1;
            string = (String)this.nodeIdFreeList.remove(n2);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer getViewId() {
        Integer n2;
        ArrayList arrayList = this.viewIdFreeList;
        synchronized (arrayList) {
            int n3 = this.viewIdFreeList.size();
            n2 = n3 == 0 ? new Integer(this.viewIdCount++) : (Integer)this.viewIdFreeList.remove(n3 - 1);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addViewIdToFreeList(Integer n2) {
        ArrayList arrayList = this.viewIdFreeList;
        synchronized (arrayList) {
            this.viewIdFreeList.add(n2);
        }
    }

    void addViewPlatform(ViewPlatformRetained viewPlatformRetained) {
        this.vpChanged = true;
        this.viewPlatforms.add(viewPlatformRetained);
    }

    void removeViewPlatform(ViewPlatformRetained viewPlatformRetained) {
        this.vpChanged = true;
        this.viewPlatforms.remove(this.viewPlatforms.indexOf(viewPlatformRetained));
    }

    synchronized Object[] getViewPlatformList() {
        if (this.vpChanged) {
            this.viewPlatformList = this.viewPlatforms.toArray();
            this.vpChanged = false;
        }
        return this.viewPlatformList;
    }

    void checkForEnableEvents() {
        this.enableComponentEvents();
        if (this.enableFocus) {
            this.enableFocusEvents();
        }
        if (this.enableKey) {
            this.enableKeyEvents();
        }
        if (this.enableMouse) {
            this.enableMouseEvents();
        }
        if (this.enableMouseMotion) {
            this.enableMouseMotionEvents();
        }
        if (this.enableMouseWheel) {
            this.enableMouseWheelEvents();
        }
    }

    void enableComponentEvents() {
    }

    void disableFocusEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableFocus = false;
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[i2];
                View[] viewArray = viewPlatformRetained.getViewList();
                for (int i3 = viewArray.length - 1; i3 >= 0; --i3) {
                    Enumeration enumeration = viewArray[i3].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.disableFocusEvents();
                    }
                }
            }
        }
    }

    void enableFocusEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableFocus = true;
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[i2];
                View[] viewArray = viewPlatformRetained.getViewList();
                for (int i3 = viewArray.length - 1; i3 >= 0; --i3) {
                    Enumeration enumeration = viewArray[i3].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.enableFocusEvents();
                    }
                }
            }
        }
    }

    void disableKeyEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableKey = false;
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[i2];
                View[] viewArray = viewPlatformRetained.getViewList();
                for (int i3 = viewArray.length - 1; i3 >= 0; --i3) {
                    Enumeration enumeration = viewArray[i3].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.disableKeyEvents();
                    }
                }
            }
        }
    }

    void enableKeyEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableKey = true;
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[i2];
                View[] viewArray = viewPlatformRetained.getViewList();
                for (int i3 = viewArray.length - 1; i3 >= 0; --i3) {
                    Enumeration enumeration = viewArray[i3].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.enableKeyEvents();
                    }
                }
            }
        }
    }

    void disableMouseEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableMouse = false;
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[i2];
                View[] viewArray = viewPlatformRetained.getViewList();
                for (int i3 = viewArray.length - 1; i3 >= 0; --i3) {
                    Enumeration enumeration = viewArray[i3].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.disableMouseEvents();
                    }
                }
            }
        }
    }

    void enableMouseEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableMouse = true;
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[i2];
                View[] viewArray = viewPlatformRetained.getViewList();
                for (int i3 = viewArray.length - 1; i3 >= 0; --i3) {
                    Enumeration enumeration = viewArray[i3].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.enableMouseEvents();
                    }
                }
            }
        }
    }

    void disableMouseMotionEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableMouseMotion = false;
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[i2];
                View[] viewArray = viewPlatformRetained.getViewList();
                for (int i3 = viewArray.length - 1; i3 >= 0; --i3) {
                    Enumeration enumeration = viewArray[i3].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.disableMouseMotionEvents();
                    }
                }
            }
        }
    }

    void enableMouseMotionEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableMouseMotion = true;
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[i2];
                View[] viewArray = viewPlatformRetained.getViewList();
                for (int i3 = viewArray.length - 1; i3 >= 0; --i3) {
                    Enumeration enumeration = viewArray[i3].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.enableMouseMotionEvents();
                    }
                }
            }
        }
    }

    void disableMouseWheelEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableMouseWheel = false;
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[i2];
                View[] viewArray = viewPlatformRetained.getViewList();
                for (int i3 = viewArray.length - 1; i3 >= 0; --i3) {
                    Enumeration enumeration = viewArray[i3].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.disableMouseWheelEvents();
                    }
                }
            }
        }
    }

    void enableMouseWheelEvents() {
        Object[] objectArray = this.getViewPlatformList();
        this.enableMouseWheel = true;
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                ViewPlatformRetained viewPlatformRetained = (ViewPlatformRetained)objectArray[i2];
                View[] viewArray = viewPlatformRetained.getViewList();
                for (int i3 = viewArray.length - 1; i3 >= 0; --i3) {
                    Enumeration enumeration = viewArray[i3].getAllCanvas3Ds();
                    while (enumeration.hasMoreElements()) {
                        Canvas3D canvas3D = (Canvas3D)enumeration.nextElement();
                        if (canvas3D.eventCatcher == null) continue;
                        canvas3D.eventCatcher.enableMouseWheelEvents();
                    }
                }
            }
        }
    }

    final void setCurrentView(View view) {
        this.currentView = view;
    }

    final View getCurrentView() {
        return this.currentView;
    }

    static ThreadGroup getRootThreadGroup() {
        return rootThreadGroup;
    }

    boolean isEmpty() {
        Enumeration enumeration = this.listOfLocales.elements();
        while (enumeration.hasMoreElements()) {
            Locale locale = (Locale)enumeration.nextElement();
            if (locale.branchGroups.isEmpty()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetWaitMCFlag() {
        Object object = this.waitLock;
        synchronized (object) {
            this.regViewWaiting = null;
            this.unRegViewWaiting = null;
            this.isSceneGraphLock = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForMC() {
        Object object = this.waitLock;
        synchronized (object) {
            if (this.unRegViewWaiting != null && (this.regViewWaiting == null || this.regViewWaiting != this.unRegViewWaiting)) {
                while (!this.unRegViewWaiting.doneUnregister) {
                    MasterControl.threadYield();
                }
                this.unRegViewWaiting.doneUnregister = false;
                this.unRegViewWaiting = null;
            }
            if (this.regViewWaiting != null) {
                while (!mc.isRegistered(this.regViewWaiting)) {
                    MasterControl.threadYield();
                }
                this.regViewWaiting = null;
            }
            this.isSceneGraphLock = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGraphStructureChangeListener(GraphStructureChangeListener graphStructureChangeListener) {
        if (graphStructureChangeListener == null) {
            return;
        }
        if (this.structureChangeListenerSet == null) {
            this.structureChangeListenerSet = new HashSet();
        }
        HashSet<GraphStructureChangeListener> hashSet = this.structureChangeListenerSet;
        synchronized (hashSet) {
            this.structureChangeListenerSet.add(graphStructureChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGraphStructureChangeListener(GraphStructureChangeListener graphStructureChangeListener) {
        if (this.structureChangeListenerSet == null) {
            return;
        }
        HashSet<GraphStructureChangeListener> hashSet = this.structureChangeListenerSet;
        synchronized (hashSet) {
            this.structureChangeListenerSet.remove(graphStructureChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyStructureChangeListeners(boolean bl, Object object, BranchGroup branchGroup) {
        if (this.structureChangeListenerSet == null) {
            return;
        }
        HashSet<GraphStructureChangeListener> hashSet = this.structureChangeListenerSet;
        synchronized (hashSet) {
            for (GraphStructureChangeListener graphStructureChangeListener : this.structureChangeListenerSet) {
                try {
                    if (bl) {
                        graphStructureChangeListener.branchGroupAdded(object, branchGroup);
                        continue;
                    }
                    graphStructureChangeListener.branchGroupRemoved(object, branchGroup);
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("Exception occurred in GraphStructureChangeListener:");
                    runtimeException.printStackTrace();
                }
                catch (Error error) {
                    System.err.println("Error occurred in GraphStructureChangeListener:");
                    error.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyStructureChangeListeners(Object object, Object object2, BranchGroup branchGroup) {
        if (this.structureChangeListenerSet == null) {
            return;
        }
        HashSet<GraphStructureChangeListener> hashSet = this.structureChangeListenerSet;
        synchronized (hashSet) {
            for (GraphStructureChangeListener graphStructureChangeListener : this.structureChangeListenerSet) {
                try {
                    graphStructureChangeListener.branchGroupMoved(object, object2, branchGroup);
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("Exception occurred in GraphStructureChangeListener:");
                    runtimeException.printStackTrace();
                }
                catch (Error error) {
                    System.err.println("Error occurred in GraphStructureChangeListener:");
                    error.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShaderErrorListener(ShaderErrorListener shaderErrorListener) {
        if (shaderErrorListener == null) {
            return;
        }
        if (this.shaderErrorListenerSet == null) {
            this.shaderErrorListenerSet = new HashSet();
        }
        HashSet<ShaderErrorListener> hashSet = this.shaderErrorListenerSet;
        synchronized (hashSet) {
            this.shaderErrorListenerSet.add(shaderErrorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeShaderErrorListener(ShaderErrorListener shaderErrorListener) {
        if (this.shaderErrorListenerSet == null) {
            return;
        }
        HashSet<ShaderErrorListener> hashSet = this.shaderErrorListenerSet;
        synchronized (hashSet) {
            this.shaderErrorListenerSet.remove(shaderErrorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyShaderErrorListeners(ShaderError shaderError) {
        boolean bl = false;
        if (this.shaderErrorListenerSet != null) {
            HashSet<ShaderErrorListener> hashSet = this.shaderErrorListenerSet;
            synchronized (hashSet) {
                for (ShaderErrorListener shaderErrorListener : this.shaderErrorListenerSet) {
                    try {
                        shaderErrorListener.errorOccurred(shaderError);
                    }
                    catch (RuntimeException runtimeException) {
                        System.err.println("Exception occurred in ShaderErrorListener:");
                        runtimeException.printStackTrace();
                    }
                    catch (Error error) {
                        System.err.println("Error occurred in ShaderErrorListener:");
                        error.printStackTrace();
                    }
                    bl = true;
                }
            }
        }
        if (!bl) {
            this.defaultShaderErrorListener.errorOccurred(shaderError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRenderingErrorListener(RenderingErrorListener renderingErrorListener) {
        if (renderingErrorListener == null) {
            return;
        }
        if (renderingErrorListenerSet == null) {
            renderingErrorListenerSet = new HashSet();
        }
        HashSet<RenderingErrorListener> hashSet = renderingErrorListenerSet;
        synchronized (hashSet) {
            renderingErrorListenerSet.add(renderingErrorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRenderingErrorListener(RenderingErrorListener renderingErrorListener) {
        if (renderingErrorListenerSet == null) {
            return;
        }
        HashSet<RenderingErrorListener> hashSet = renderingErrorListenerSet;
        synchronized (hashSet) {
            renderingErrorListenerSet.remove(renderingErrorListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyRenderingErrorListeners(RenderingError renderingError) {
        boolean bl = false;
        if (renderingErrorListenerSet != null) {
            HashSet<RenderingErrorListener> hashSet = renderingErrorListenerSet;
            synchronized (hashSet) {
                for (RenderingErrorListener renderingErrorListener : renderingErrorListenerSet) {
                    try {
                        renderingErrorListener.errorOccurred(renderingError);
                    }
                    catch (RuntimeException runtimeException) {
                        System.err.println("Exception occurred in RenderingErrorListener:");
                        runtimeException.printStackTrace();
                    }
                    catch (Error error) {
                        System.err.println("Error occurred in RenderingErrorListener:");
                        error.printStackTrace();
                    }
                    bl = true;
                }
            }
        }
        if (!bl) {
            defaultRenderingErrorListener.errorOccurred(renderingError);
        }
    }

    static {
        String string;
        StringBuffer stringBuffer;
        mc = null;
        properties = null;
        renderingErrorListenerSet = null;
        defaultRenderingErrorListener = Renderer.getDefaultErrorListener();
        boolean bl = MasterControl.isCoreLoggable(Level.CONFIG);
        Logger logger = MasterControl.getCoreLogger();
        if (bl) {
            stringBuffer = new StringBuffer("Java 3D ");
            stringBuffer.append(VersionInfo.getVersion());
            string = stringBuffer.toString();
            if (bl) {
                logger.config(string);
            } else {
                System.err.println(string);
                System.err.println();
            }
        }
        if (bl) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("Initializing Java 3D runtime system:\n").append("    version = ").append(VersionInfo.getVersion()).append("\n").append("    vendor = ").append(VersionInfo.getVendor()).append("\n").append("    specification.version = ").append(VersionInfo.getSpecificationVersion()).append("\n").append("    specification.vendor = ").append(VersionInfo.getSpecificationVendor());
            string = stringBuffer.toString();
            if (bl) {
                logger.config(string);
            } else {
                System.err.println(string);
                System.err.println();
            }
        }
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        MasterControl.loadLibraries();
        mc = new MasterControl();
        if (bl) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("Java 3D system initialized\n").append("    rendering pipeline = ").append(Pipeline.getPipeline().getPipelineName());
            string = stringBuffer.toString();
            if (bl) {
                logger.config(string);
            } else {
                System.err.println(string);
                System.err.println();
            }
        }
    }
}

